<?php

namespace psychizen\LaravelInstaller\Controllers;

use Illuminate\Routing\Controller;
use psychizen\LaravelInstaller\Events\LaravelInstallerFinished;
use psychizen\LaravelInstaller\Helpers\EnvironmentManager;
use psychizen\LaravelInstaller\Helpers\FinalInstallManager;
use psychizen\LaravelInstaller\Helpers\InstalledFileManager;

class FinalController extends Controller
{
    /**
     * Update installed file and display finished view.
     *
     * @param \psychizen\LaravelInstaller\Helpers\InstalledFileManager $fileManager
     * @param \psychizen\LaravelInstaller\Helpers\FinalInstallManager $finalInstall
     * @param \psychizen\LaravelInstaller\Helpers\EnvironmentManager $environment
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function finish(InstalledFileManager $fileManager, FinalInstallManager $finalInstall, EnvironmentManager $environment)
    {
        $finalMessages = $finalInstall->runFinal();
        $finalStatusMessage = $fileManager->update();
        $finalEnvFile = $environment->getEnvContent();

        event(new LaravelInstallerFinished);

        return view('vendor.installer.finished', compact('finalMessages', 'finalStatusMessage', 'finalEnvFile'));
    }
}
